function [allmeanspectra,idx]=kmeansclustering(Aproj_final,PCs,khat,subcoords,mzaxis,finaldata);
%This command will perform kmeans clustering on the scores of the relevant
%principal components of the processed data.  It will plot a heat map of 
%where the clusters of data are located spatially.  You input your data, 
%the number of clusters, and the coordinates.  The output will contain two 
%graphs:  a graph of average spectra for all pixels within a certain group 
%and a color-coded clustering pixel map.  The color scheme for the spatial 
%map will change if the number of clusters does not equal three.

%INPUTS:
%Aproj_final - This contains the scores of each relevant principal component for 
%each pixel.  The number of rows indicates the number of principal 
%components and the number of columns indicates the number of pixels.  

%PCs - The number of PCs athat are relevant.  The output from the mzPCA 
%command will give 20 PCs by default.  However, you only want to cluster 
%using the proper number of PCs.  Therefore, type in the number of PCs that
%are relevant (must be less than the total number of rows of Aproj).  If
%more than 20 are needed, the mzPCA_processed command must be adapted.

%khat - This is the estimate of the number of clusters that exist.  This
%comes from the gap statistic or prior knowledge of the user.

%subcoords - This are the XY coordinates of the selected relevant pixels.
%This was the output from the plotandselect command.

%mzaxis - This is the m/z axis for the spectra.

%finaldata - This is the matrix containing the processed, aligned, 
%and normalized data.  This should have been the output of the
%align_and_normalize command.

%OUTPUTS:
%allmeanspectra - This contains a set of the average processed, aligned,
%normalized spectra for all pixels of a particular group.  The first row
%corresponds to the first cluster and so on.

%idx - This is an array of indices specifiying which pixels/mass spectra
%correspond to which cluster.

Aproj_final(PCs+1:end,:)=[];

Aproj_final=Aproj_final';

idx=kmeans(Aproj_final,khat,'replicates',5);
rows=max(subcoords(:,1));
columns=max(subcoords(:,2));
image1=zeros(rows,columns);
[a,b]=size(subcoords);
for x=1:a
    image1(subcoords(x,1),subcoords(x,2))=idx(x);
end

%The following creates a heat map of clusters.
figure;imagesc(image1')
colorbar
%the next two commands set an arbitray color map.  If the user wishes,
%these two commands can be commented out to restore the default jet
%colormap
if khat==3
hh=[0,0,0;0.00227038189768791,0.0272445827722549,0.0410732738673687;0.00454076379537582,0.0544891655445099,0.0821465477347374;0.00681114569306374,0.0817337483167648,0.123219817876816;0.00908152759075165,0.108978331089020,0.164293095469475;0.0113519094884396,0.136222913861275,0.205366358160973;0.0136222913861275,0.163467496633530,0.246439635753632;0.0158926732838154,0.190712079405785,0.287512898445129;0.0181630551815033,0.217956662178040,0.328586190938950;0.0204334370791912,0.245201244950295,0.369659453630447;0.0227038189768791,0.272445827722549,0.410732716321945;0.0249742008745670,0.299690425395966,0.451805979013443;0.0272445827722549,0.326934993267059,0.492879271507263;0.0295149646699429,0.354179590940475,0.533952534198761;0.0317853465676308,0.381424158811569,0.575025796890259;0.0340557284653187,0.408668756484985,0.616099059581757;0.0363261103630066,0.435913324356079,0.657172381877899;0.0385964922606945,0.463157922029495,0.698245644569397;0.0408668741583824,0.490402489900589,0.739318907260895;0.0431372560560703,0.517647087574005,0.780392169952393;0.0412617214024067,0.516794562339783,0.746462047100067;0.0393861904740334,0.515942037105560,0.712531983852387;0.0375106558203697,0.515089511871338,0.678601861000061;0.0356351248919964,0.514237046241760,0.644671797752380;0.0337595902383328,0.513384521007538,0.610741674900055;0.0318840593099594,0.512531995773315,0.576811611652374;0.0300085265189409,0.511679470539093,0.542881488800049;0.0281329937279224,0.510826945304871,0.508951425552368;0.0262574609369040,0.509974420070648,0.475021332502365;0.0243819281458855,0.509121954441071,0.441091239452362;0.0225063953548670,0.508269429206848,0.407161146402359;0.0206308607012033,0.507416903972626,0.373231023550034;0.0187553279101849,0.506564378738403,0.339300930500031;0.0168797951191664,0.505711853504181,0.305370837450027;0.0150042632594705,0.504859328269959,0.271440744400024;0.0131287304684520,0.504006803035736,0.237510666251183;0.0112531976774335,0.503154337406158,0.203580573201180;0.00937766395509243,0.502301812171936,0.169650465250015;0.00750213162973523,0.501449286937714,0.135720372200012;0.00562659883871675,0.500596761703491,0.101790286600590;0.00375106581486762,0.499744236469269,0.0678601861000061;0.00187553290743381,0.498891741037369,0.0339300930500031;0,0.498039215803146,0;0.0500000007450581,0.473137259483337,0;0.100000001490116,0.448235303163528,0;0.150000005960464,0.423333346843720,0;0.200000002980232,0.398431360721588,0;0.250000000000000,0.373529404401779,0;0.300000011920929,0.348627448081970,0;0.349999994039536,0.323725491762161,0;0.400000005960465,0.298823535442352,0;0.449999988079071,0.273921579122543,0;0.500000000000000,0.249019607901573,0;0.550000011920929,0.224117651581764,0;0.600000023841858,0.199215680360794,0;0.649999976158142,0.174313724040985,0;0.699999988079071,0.149411767721176,0;0.750000000000000,0.124509803950787,0;0.800000011920929,0.0996078401803970,0;0.850000023841858,0.0747058838605881,0;0.899999976158142,0.0498039200901985,0;0.949999988079071,0.0249019600450993,0;1,0,0;1,0,0];
colormap(hh);
end
set(gcf, 'color', 'white');
box off
set(gca,'FontSize',16)
xlabel('X Coordinate','FontSize',16)
ylabel('Y Coordinate','FontSize',16)
h=colorbar;
set(h,'fontsize',16);
set(h,'YTick',[0:1:khat])
clear rows columns a b x 

%The following makes a graph of the average processed spectra:
for x=1:khat
    a=find(idx==x);
    allmeanspectra(x,:)=mean(finaldata(a,:),1);
end
figure;plot(mzaxis,allmeanspectra','LineWidth',2)
set(gcf, 'color', 'white');
legend('show')
xlabel('Mass to Charge Ratio (m/z)','FontSize',16)
ylabel('Intensity','FontSize',16)
set(gca,'FontSize',16)


